unit S5Link_Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  S5Link, StdCtrls, ComCtrls, Menus, Buttons, ExtCtrls, Matrix,
  Mask, BorBtns;

resourcestring
  csSpace5    = '     ';
  csSpace10   = '          ';
  csByte      = ' Bytes';
  csRun       = 'RUN';
  csStop      = 'STOP';
  csUngueltig = 'UNGUELTIG';
  csLine      = '-----';
  csCompress  = 'AG - Speicher wird komprimiert';

type
  TfrmMain = class(TForm)
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    BitBtn11: TBitBtn;
    BitBtn12: TBitBtn;
    BitBtn13: TBitBtn;
    BitBtn14: TBitBtn;
    BitBtn15: TBitBtn;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Bevel2: TBevel;
    StatusBar1: TStatusBar;
    S5Link1: TS5Link;
    ComboBox1: TComboBox;
    UpDown1: TUpDown;
    StaticText1: TStaticText;
    Label15: TLabel;
    UpDown2: TUpDown;
    StaticText2: TStaticText;
    Label3: TLabel;
    UpDown3: TUpDown;
    StaticText3: TStaticText;
    Label4: TLabel;
    UpDown4: TUpDown;
    StaticText4: TStaticText;
    Label6: TLabel;
    BorRadio1: TBorRadio;
    BorRadio2: TBorRadio;
    BorRadio3: TBorRadio;
    BorRadio4: TBorRadio;
    BorRadio5: TBorRadio;
    BorRadio6: TBorRadio;
    BorRadio7: TBorRadio;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    ListBox1: TListBox;
    StaticText5: TStaticText;
    UpDown5: TUpDown;
    StaticText6: TStaticText;
    UpDown6: TUpDown;
    Label1: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    BitBtn1: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn9Click(Sender: TObject);
    procedure BitBtn11Click(Sender: TObject);
    procedure BitBtn12Click(Sender: TObject);
    procedure BitBtn14Click(Sender: TObject);
    procedure BitBtn15Click(Sender: TObject);
    procedure BitBtn13Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn10Click(Sender: TObject);
    procedure BorRadio1Click(Sender: TObject);
    procedure BitBtn17Click(Sender: TObject);
    procedure BorRadio2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    wBuffer   : TWordBuffer;
    bTextSel  : Byte;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  S5Link1.Active := True;
  if not S5Link1.Active then begin
   InfoDlg('                       Die SPS ist nicht ONLINE !!!' + #10#13#13 +
           'Bitte kontrollieren Sie die Kabelverbindung und Ihre SPS.' + #10#13#13 +
           'Fr diese Demo muss das TTY - Kabel auf COM1 gesteckt sein.' + #10#13 +
           'Desweiteren darf die Schnittstelle nicht durch einen Fax -' + #10#13 +
           'treiber, DF -Netzwerk etc. belegt sein  sein.' + #10#13#13 +
           '                    Das Programm wird beendet ...');

    Application.Terminate;
  end;
  ComboBox1.Text := ComboBox1.Items[4];
  bTextSel := 1;
  UpDown1.Position := 1;
  UpDown2.Position := 10;
  UpDown3.Position := 0;
  UpDown4.Position := 50;
  UpDown5.Position := 0;
  UpDown6.Position := 6;
  Randomize;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  if S5Link1.Active then
    S5Link1.Active := False;
end;

procedure TfrmMain.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.BitBtn4Click(Sender: TObject);
var wDummy : Word;

begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      BstNr := StrToInt(StaticText2.Caption);
      AbWort :=StrToInt(StaticText5.Caption);
      Anzahl :=StrToInt(StaticText6.Caption);
      Command := ReadDBData;
      StatusBar1.Panels[0].Text := 'Lese Daten';
      StatusBar1.Update;
      if Execute(@wBuffer) then begin
        ListBox1.Items.Clear;
        ListBox1.Items.Add(StaticText6.Caption + ' DW gelesen aus DB ' +
        StaticText2.Caption + ' ab DW ' + StaticText5.Caption + ' : ');
        ListBox1.Items.Add('');
        for wDummy := 0 to Anzahl - 1 do begin
          ListBox1.Items.Add(IntToHex(wDummy, 4) + ' :   ' + IntToHex(wBuffer[wDummy], 4));
        end;
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn7Click(Sender: TObject);
var  wDummy   : Word;
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      BstNr := StrToInt(StaticText2.Caption);
      AbWort :=StrToInt(StaticText5.Caption);
      Anzahl :=StrToInt(StaticText6.Caption);
      for wDummy := 0 to Anzahl - 1 do
        wBuffer[wDummy] := Random($FFFF);
      Command := WriteDBData;
      StatusBar1.Panels[0].Text := 'Schreibe Datenbaustein 11';
      StatusBar1.Update;
      if Execute(@wBuffer) then begin
        ListBox1.Items.Clear;
        ListBox1.Items.Add(StaticText6.Caption + ' DW geschrieben in DB ' +
        StaticText2.Caption + ' ab DW ' + StaticText5.Caption + ' : ');
        ListBox1.Items.Add('');
        for wDummy := 0 to Anzahl - 1 do begin
          ListBox1.Items.Add(IntToHex(wDummy, 4) + ' :   ' + IntToHex(wBuffer[wDummy], 4));
        end;
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn5Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      BstNr := StrToInt(StaticText3.Caption);
      Command := ReadEW;
      StatusBar1.Panels[0].Text := 'Lese Eingangswort';
      StatusBar1.Update;
      if Execute(@wBuffer) then begin
        ListBox1.Items.Clear;
        ListBox1.Items.Add('EW ' + StaticText3.Caption + ' :');
        ListBox1.Items.Add('');
        ListBox1.Items.Add(IntToHex(wBuffer[0], 4));
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn8Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    wBuffer[0] := Random($FFFF);
    with S5Link1 do begin
      BstNr := StrToInt(StaticText3.Caption);
      Command := WriteAW;
      StatusBar1.Panels[0].Text := 'Schreibe Ausgangswort';
      StatusBar1.Update;
      if Execute(@wBuffer) then begin
        ListBox1.Items.Clear;
        ListBox1.Items.Add('AW ' + StaticText3.Caption + ' :');
        ListBox1.Items.Add('');
        ListBox1.Items.Add(IntToHex(wBuffer[0], 4));
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn6Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      BstNr := StrToInt(StaticText4.Caption);
      Command := ReadMW;
      StatusBar1.Panels[0].Text := 'Lese Merkerwort';
      StatusBar1.Update;
      if Execute(@wBuffer) then begin
        ListBox1.Items.Clear;
        ListBox1.Items.Add('MW ' + StaticText4.Caption + ' :');
        ListBox1.Items.Add('');
        ListBox1.Items.Add(IntToHex(wBuffer[0], 4));
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn9Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    wBuffer[0] := Random($FFFF);
    with S5Link1 do begin
      BstNr := StrToInt(StaticText4.Caption);
      Command := WriteMW;
      StatusBar1.Panels[0].Text := 'Schreibe Ausgangswort';
      StatusBar1.Update;
      if Execute(@wBuffer) then begin
        ListBox1.Items.Clear;
        ListBox1.Items.Add('MW ' + StaticText4.Caption + ' :');
        ListBox1.Items.Add('');
        ListBox1.Items.Add(IntToHex(wBuffer[0], 4));
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn11Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      Command := Stop;
      StatusBar1.Panels[0].Text := 'SPS wird gestoppt';
      StatusBar1.Update;
      if Execute(NIL) then begin
        BitBtn14Click(Self);
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn12Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      Command := Start;
      StatusBar1.Panels[0].Text := 'SPS wird gestartet';
      StatusBar1.Update;
      if Execute(NIL) then begin
        BitBtn14Click(Self);
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn14Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      StatusBar1.Panels[0].Text := 'SPS - Status wird geprft ...';
      StatusBar1.Update;
      if S5Link1.CheckPLC(S5Link1.PLC) then begin
        Shape1.Brush.Color := Graphics.clLime;
        Shape2.Brush.Color := Graphics.clMaroon;
      end else begin
        Shape1.Brush.Color := Graphics.clGreen;
        Shape2.Brush.Color := Graphics.clRed;
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
end;

procedure TfrmMain.BitBtn15Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    StatusBar1.Panels[0].Text := 'SPS Pufferbatterie wird geprft ...';
    StatusBar1.Update;
    if S5Link1.CheckBatt(S5Link1.PLC) then
      Shape3.Brush.Color := Graphics.clOlive
    else
      Shape3.Brush.Color := Graphics.clYellow;
    StatusBar1.Panels[0].Text := 'Bereit ...';
    StatusBar1.Panels[1].Text :=  S5Link1.GetErrText(S5Link1.PLC.Error);
  end;
end;

procedure TfrmMain.BitBtn13Click(Sender: TObject);
begin
  if S5Link1.Active then begin
    with S5Link1 do begin
      ShowInfo('Bitte warten ...' , csCompress);
      Command := Compress;
      StatusBar1.Panels[0].Text := csCompress;
      StatusBar1.Update;
      Execute(NIL);
      HideInfo;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
      HideInfo;
    end;
  end;
end;

procedure TfrmMain.BitBtn3Click(Sender: TObject);
var wDummy : Word;
    OB1    : TBaustein;
    Lines  : TStringList;

  procedure ShowKH;
  var wLoop  : Word;
  begin
    for wLoop := 0 to wDummy do
      ListBox1.Items.Add(IntToHex(wLoop, 4) + ' :   ' + IntToHex(wBuffer[wLoop], 4));
  end;

  procedure ShowKF;
  var wLoop  : Word;
      VZ     : Char;
  begin
    for wLoop := 0 to wDummy do begin
      if TestBit(wBuffer[wLoop], 15) then begin
        VZ := '-';
        ListBox1.Items.Add(IntToHex(wLoop, 4) + ' :   ' + VZ + IntToStr(65536 - wBuffer[wLoop]));
      end else begin
        VZ := '+';
        ListBox1.Items.Add(IntToHex(wLoop, 4) + ' :   ' + VZ + IntToStr(wBuffer[wLoop]));
      end;
    end;
  end;

  procedure ShowKY;
  var wLoop  : Word;
  begin
    for wLoop := 0 to wDummy do
      ListBox1.Items.Add(IntToHex(wLoop, 4) + ' :   ' + IntToStr(Hi(wBuffer[wLoop])) + ',' + IntToStr(Lo(wBuffer[wLoop])));
  end;

  procedure ShowKM;
  var wLoop  : Word;
  begin
    for wLoop := 0 to wDummy do
      ListBox1.Items.Add(IntToHex(wLoop, 4) + ' :   ' + WordToBin(wBuffer[wLoop]));
  end;

  procedure ShowKT;
  var wLoop  : Word;
      wVal   : Word;
      wRes   : Word;
  begin
    for wLoop := 0 to wDummy do begin
      DecodeTimer(wBuffer[wLoop], wVal, wRes);
      ListBox1.Items.Add(IntToHex(wLoop, 4) + ' :   ' + IntToStr(wVal) + '.' + IntToStr(wRes));
    end;
  end;

  procedure ShowKC;
  var wLoop  : Word;
      sDummy : String;
      bLoop  : Byte;
      wStart : Word;

  begin
    bLoop := 0;
    wStart := 1;
    sDummy := '';
    for wLoop := 0 to wDummy do begin
      sDummy := sDummy + Char(Hi(wBuffer[wLoop])) + Char(Lo(wBuffer[wLoop]));
      Inc(bLoop);
      if (bLoop = 8) then begin
        ListBox1.Items.Add(IntToHex((wStart - 1) * 16, 4) + ' :   ' + sDummy);
        bLoop := 0;
        sDummy := '';
        Inc(wStart);
      end;
    end;
    if sDummy <> '' then
      ListBox1.Items.Add(IntToHex((wStart - 1) * 16, 4) + ' :   ' + sDummy);
  end;

  procedure ShowAWL;
  var  wLoop : Word;
  begin
    for wLoop := 0 to Lines.Count - 1 do
      ListBox1.Items.Add(Lines[wLoop]);
  end;

begin
  ListBox1.Items.Clear;
  if S5Link1.Active then begin
    with S5Link1 do begin
      BstTyp := TBstTyp(ComboBox1.Items.IndexOf(ComboBox1.Text));
      BstNr := StrToInt(StaticText1.Caption);
      Command := ReadBst;
      StatusBar1.Panels[0].Text := 'Lese Baustein';
      StatusBar1.Update;
      if Execute(@OB1) then begin
        wDummy := Swap(OB1.LaengeMitKopf) - (PLC.System.BstKopflaenge SHR 1) - 1;
        Move(OB1.Daten, wBuffer, wDummy SHL 2);
        Lines := S5Link1.AgDecodeBst(S5Link1.PLC, OB1, True);
        case bTextSel of
          $01 : ShowKH;
          $02 : ShowKF;
          $04 : ShowKY;
          $08 : ShowKM;
          $10 : ShowKT;
          $20 : ShowKC;
          $40 : ;
          $80 : ShowAWL;
        end;
      end;
      StatusBar1.Panels[0].Text := 'Bereit ...';
      StatusBar1.Panels[1].Text :=  GetErrText(PLC.Error);
    end;
  end;
  Lines.Free;
end;

procedure TfrmMain.BitBtn10Click(Sender: TObject);
begin
  InfoDlg('Diese Funktion ist momentan in der Demo, aus Zeitgrnden,' + #10#13 +
          'noch nicht implementiert,ist jedoch in der Komponente' + #10#13 +
          'bereits vollstndig getestet als Funktion vorhanden ...');
end;

procedure TfrmMain.BorRadio1Click(Sender: TObject);
begin
  with (Sender as TBorRadio) do begin
    if Checked then begin
      bTextSel := 1 SHL StrToInt(Hint);
    end;
  end;
end;

procedure TfrmMain.BitBtn17Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.BorRadio2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  InfoDlg('Diese Funktion ist momentan noch nicht vollstndig !' + #10#13 +
          'In Bausteinen mit Parametrierbaren FB aufrufen,direkt' + #10#13 +
          'in FB''s und bei Sprungmerkern, knnen falsche Resultate' + #10#13 +
          'entstehen. Diese Funktion wird jedoch kurzfristig ber -' + #10#13 +
          'arbeitet und vervollstndigt ...' + #10#13#13 +
          'Hauptschlich soll diese Funktion auch nur als Beispiel dienen ...' + #10#13#13);
end;

end.




